<?php
/*
Plugin Name: NextFlip Flip Book
Plugin URI: http://nextflipbook.com
Description: NextFlip Flip Book WordPress Plugin
Version: 1.0
Author: Nextflip
Author URI: http://nextflipbook.com
License: Copyright 2014 Nextflip Ltd, All Rights Reserved
*/

define('NEXTFLIPBOOK_VERSION', '1.0');

define('NEXTFLIPBOOK_URL', plugin_dir_url( __FILE__ ));

define('NEXTFLIPBOOK_PATH', plugin_dir_path( __FILE__ ));

require_once 'app/class-nextflipbook-controller.php';

class NextFlipBook_Plugin

{
	public $nextflipbook_controller;
	
	function __construct() {
		
		$this->init();
	}
	
	public function init()
	{
		
		$this->nextflipbook_controller = new NextFlipBook_Controller();

		register_activation_hook( __FILE__, array($this, 'activation_handler') );
		
		add_action( 'admin_menu', array($this, 'register_menu') );
		
		add_shortcode( 'nextflipbook', array($this, 'shortcode_handler') );
		
		add_action( 'init', array($this, 'register_script') );
		add_action( 'wp_enqueue_scripts', array($this, 'enqueue_script') );
		add_action( 'admin_enqueue_scripts', array($this, 'enqueue_admin_script') );
	}
	
	function activation_handler()
	{
		$this->nextflipbook_controller->activation_handler();
	}
	
	function enqueue_admin_script($hook)

	{

	}
	
	function enqueue_script()
	{
		//wp_enqueue_script('firstflip-script');
	}
	
	function register_script()
	{
		$uploads = wp_upload_dir();		
		
		if ( is_admin() )

		{

			wp_register_style('nextflipbook-style', NEXTFLIPBOOK_URL . 'nextflipbook.css');

			wp_enqueue_style('nextflipbook-style');

		}
	}
	
	function shortcode_handler($atts)
	{
		if ( !isset($atts['id']) )
			return __('Please specify a book id', 'nextflipbook');
		
		$id = $atts['id'];
		return $this->nextflipbook_controller->generate_body_code($id);
	}
	
	function register_menu()
	{
		add_menu_page( 
				__('NextFlip Flip Book', 'nextflipbook'), 
				__('NextFlip Flip Book', 'nextflipbook'), 
				'manage_options', 
				'nextflipbook_show_books', 
				array($this, 'show_books'),
				NEXTFLIPBOOK_URL . 'images/logo-16.png' );
				
		add_submenu_page(
				'nextflipbook_show_books', 
				__('Installed Books', 'nextflipbook'), 
				__('Installed Books', 'nextflipbook'), 
				'manage_options',
				'nextflipbook_show_books',
				array($this, 'show_books' ) );
		
		add_submenu_page(

				'nextflipbook_show_books',

				__('Add New', 'nextflipbook'),

				__('Add New', 'nextflipbook'),

				'manage_options',

				'nextflipbook_add_new',

				array($this, 'add_new' ) );
		
		add_submenu_page(

				null,

				__('View Book', 'nextflipbook'),

				__('View Book', 'nextflipbook'),

				'manage_options',

				'nextflipbook_view_book',

				array($this, 'view_book' ) );
	}
	
	public function show_books()
	{
		$this->nextflipbook_controller->show_books();
	}
	
	public function add_new()
	{
		$this->nextflipbook_controller->add_new();
	}
	
	public function view_book()
	{
		$this->nextflipbook_controller->view_book();
	}
}

$nextflipbook_plugin = new NextFlipBook_Plugin();

/**
 * Global php function
 * @param unknown_type $id
 */
function nextflipbook($id) {
	
	echo $nextflipbook_plugin->nextflipbook_controller->generate_body_code($id);
}

/**
 * Uninstallation
 */
function nextflipbook_uninstall() {


	global $wpdb;
	

	$table_name = $wpdb->prefix . "nextflipbook";

	$wpdb->query("DROP TABLE IF EXISTS $table_name");

}

if ( function_exists('register_uninstall_hook') )
	register_uninstall_hook( __FILE__, 'nextflipbook_uninstall' );

